import type { NextConfig } from "next";

const nextConfig: NextConfig = {
  /* config options here */
  reactCompiler: true,

  typescript: {
    ignoreBuildErrors: true, // Ignores TypeScript errors during the production build
  },
  images: {
    remotePatterns: [
      {
        protocol: "http",
        hostname: "localhost",
        port: "8080",
        pathname: "/**",
      },
      {
        protocol: "https",
        hostname: "admin.texexcellance.com",
        port: "",
        pathname: "/**",
      },
    ],
  },
  distDir: "build",
};

export default nextConfig;
